entity prpt is
  port(seed       : in bit_vector(31 downto 0);
       load_seed  : in bit;  
       polynomial : in bit_vector(31 downto 0);
       reset      : in bit;
       clock1     : in bit;
       clock1_bar : in bit;
       clock2     : in bit;
       clock2_bar : in bit;
       test_enable: in bit;
       pattern    : out bit_vector(31 downto 0));
begin
  assert (((not clock1 = clock1_bar) or (not clock1'stable(2 ns))) 
    or (now = 0 ns)) report
    "bad clock1 result" severity failure;
--  assert ((not clock2 = clock2_bar) or (not clock2'stable(2 ns))) report
--    "bad clock2 result" severity failure;
end prpt;

architecture structural of prpt is

  component prpt_stage 
    port(seed       : in bit;
         load_seed  : in bit;
         polynomial : in bit;
         feed_in    : in bit;
         reset      : in bit;
         input      : in bit;
         clock1     : in bit;
         clock1_bar : in bit;
         clock2     : in bit;
         clock2_bar : in bit;
         test_enable: in bit;
         feed_out   : out bit;
         output     : out bit);
  end component;

  for all : prpt_stage use entity work.prpt_stage(structural);

  component prpt_stage1 
    port(seed       : in bit;
         load_seed  : in bit;
         reset      : in bit;
         input      : in bit;
         clock1     : in bit;
         clock1_bar : in bit;
         clock2     : in bit;
         clock2_bar : in bit;
         test_enable: in bit;
         output     : out bit);
  end component;

  for all : prpt_stage1 use entity work.prpt_stage1(structural);

  component and_gate
    port  (signal X,Y:in bit;
           signal Output:out bit);
  end component;

  for all : and_gate use entity work.and_gate( and_gate );

  component inv
    generic(constant tPLH:TIME:=0 ns;
            constant tPHL:TIME:=0 ns);
    port (signal A:in bit;
          signal B:out bit);
  end component;

  for all : inv use entity work.inv( inv );

  signal feedback : bit_vector(31 downto 0);
  signal i_o,temp : bit_vector(31 downto 0);

begin
 
  prpt_stage1_1 : prpt_stage1
    port map(seed(31),load_seed,reset,feedback(31),clock1,clock1_bar,
             clock2,clock2_bar,test_enable,i_o(31)); 

  prpt_stage01 : prpt_stage 
    port map(seed(30),load_seed,polynomial(31),feedback(30),reset,i_o(31),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(31),i_o(30));
  prpt_stage2 : prpt_stage 
    port map(seed(29),load_seed,polynomial(30),feedback(29),reset,i_o(30),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(30),i_o(29));
  prpt_stage3 : prpt_stage 
    port map(seed(28),load_seed,polynomial(29),feedback(28),reset,i_o(29),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(29),i_o(28));
  prpt_stage4 : prpt_stage 
    port map(seed(27),load_seed,polynomial(28),feedback(27),reset,i_o(28),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(28),i_o(27));
  prpt_stage5 : prpt_stage 
    port map(seed(26),load_seed,polynomial(27),feedback(26),reset,i_o(27),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(27),i_o(26));
  prpt_stage6 : prpt_stage 
    port map(seed(25),load_seed,polynomial(26),feedback(25),reset,i_o(26),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(26),i_o(25));
  prpt_stage7 : prpt_stage 
    port map(seed(24),load_seed,polynomial(25),feedback(24),reset,i_o(25),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(25),i_o(24));
  prpt_stage8 : prpt_stage 
    port map(seed(23),load_seed,polynomial(24),feedback(23),reset,i_o(24),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(24),i_o(23));
  prpt_stage9 : prpt_stage 
    port map(seed(22),load_seed,polynomial(23),feedback(22),reset,i_o(23),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(23),i_o(22));
  prpt_stage10 : prpt_stage 
    port map(seed(21),load_seed,polynomial(22),feedback(21),reset,i_o(22),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(22),i_o(21));
  prpt_stage11 : prpt_stage 
    port map(seed(20),load_seed,polynomial(21),feedback(20),reset,i_o(21),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(21),i_o(20));
  prpt_stage12 : prpt_stage 
    port map(seed(19),load_seed,polynomial(20),feedback(19),reset,i_o(20),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(20),i_o(19));
  prpt_stage13 : prpt_stage 
    port map(seed(18),load_seed,polynomial(19),feedback(18),reset,i_o(19),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(19),i_o(18));
  prpt_stage14 : prpt_stage 
    port map(seed(17),load_seed,polynomial(18),feedback(17),reset,i_o(18),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(18),i_o(17));
  prpt_stage15 : prpt_stage 
    port map(seed(16),load_seed,polynomial(17),feedback(16),reset,i_o(17),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(17),i_o(16));
  prpt_stage16 : prpt_stage 
    port map(seed(15),load_seed,polynomial(16),feedback(15),reset,i_o(16),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(16),i_o(15));
  prpt_stage17 : prpt_stage 
    port map(seed(14),load_seed,polynomial(15),feedback(14),reset,i_o(15),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(15),i_o(14));
  prpt_stage18 : prpt_stage 
    port map(seed(13),load_seed,polynomial(14),feedback(13),reset,i_o(14),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(14),i_o(13));
  prpt_stage19 : prpt_stage 
    port map(seed(12),load_seed,polynomial(13),feedback(12),reset,i_o(13),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(13),i_o(12));
  prpt_stage20 : prpt_stage 
    port map(seed(11),load_seed,polynomial(12),feedback(11),reset,i_o(12),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(12),i_o(11));
  prpt_stage21 : prpt_stage 
    port map(seed(10),load_seed,polynomial(11),feedback(10),reset,i_o(11),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(11),i_o(10));
  prpt_stage22 : prpt_stage 
    port map(seed(9),load_seed,polynomial(10),feedback(9),reset,i_o(10),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(10),i_o(9));
  prpt_stage23 : prpt_stage 
    port map(seed(8),load_seed,polynomial(9),feedback(8),reset,i_o(9),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(9),i_o(8));
  prpt_stage24 : prpt_stage 
    port map(seed(7),load_seed,polynomial(8),feedback(7),reset,i_o(8),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(8),i_o(7));
  prpt_stage25 : prpt_stage 
    port map(seed(6),load_seed,polynomial(7),feedback(6),reset,i_o(7),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(7),i_o(6));
  prpt_stage26 : prpt_stage 
    port map(seed(5),load_seed,polynomial(6),feedback(5),reset,i_o(6),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(6),i_o(5));
  prpt_stage27 : prpt_stage 
    port map(seed(4),load_seed,polynomial(5),feedback(4),reset,i_o(5),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(5),i_o(4));
  prpt_stage28 : prpt_stage 
    port map(seed(3),load_seed,polynomial(4),feedback(3),reset,i_o(4),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(4),i_o(3));
  prpt_stage29 : prpt_stage 
    port map(seed(2),load_seed,polynomial(3),feedback(2),reset,i_o(3),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(3),i_o(2));
  prpt_stage30 : prpt_stage 
    port map(seed(1),load_seed,polynomial(2),feedback(1),reset,i_o(2),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(2),i_o(1));
  prpt_stage31 : prpt_stage 
    port map(seed(0),load_seed,polynomial(1),feedback(0),reset,i_o(1),
             clock1,clock1_bar,clock2,clock2_bar,test_enable,feedback(1),i_o(0));

  and_gate1 : and_gate port map(polynomial(0),i_o(0),feedback(0));

  inv1 : inv port map(i_o(31),temp(31));
  inv2 : inv port map(i_o(30),temp(30));
  inv3 : inv port map(i_o(29),temp(29));
  inv4 : inv port map(i_o(28),temp(28));
  inv5 : inv port map(i_o(27),temp(27));
  inv6 : inv port map(i_o(26),temp(26));
  inv7 : inv port map(i_o(25),temp(25));
  inv8 : inv port map(i_o(24),temp(24));
  inv9 : inv port map(i_o(23),temp(23));
  inv10 : inv port map(i_o(22),temp(22));
  inv11 : inv port map(i_o(21),temp(21));
  inv12 : inv port map(i_o(20),temp(20));
  inv13 : inv port map(i_o(19),temp(19));
  inv14 : inv port map(i_o(18),temp(18));
  inv15 : inv port map(i_o(17),temp(17));
  inv16 : inv port map(i_o(16),temp(16));
  inv17 : inv port map(i_o(15),temp(15));
  inv18 : inv port map(i_o(14),temp(14));
  inv19 : inv port map(i_o(13),temp(13));
  inv20 : inv port map(i_o(12),temp(12));
  inv21 : inv port map(i_o(11),temp(11));
  inv22 : inv port map(i_o(10),temp(10));
  inv23 : inv port map(i_o(9),temp(9));
  inv24 : inv port map(i_o(8),temp(8));
  inv25 : inv port map(i_o(7),temp(7));
  inv26 : inv port map(i_o(6),temp(6));
  inv27 : inv port map(i_o(5),temp(5));
  inv28 : inv port map(i_o(4),temp(4));
  inv29 : inv port map(i_o(3),temp(3));
  inv30 : inv port map(i_o(2),temp(2));
  inv31 : inv port map(i_o(1),temp(1));
  inv32 : inv port map(i_o(0),temp(0));
  inv33 : inv port map(temp(31),pattern(31));
  inv34 : inv port map(temp(30),pattern(30));
  inv35 : inv port map(temp(29),pattern(29));
  inv36 : inv port map(temp(28),pattern(28));
  inv37 : inv port map(temp(27),pattern(27));
  inv38 : inv port map(temp(26),pattern(26));
  inv39 : inv port map(temp(25),pattern(25));
  inv40 : inv port map(temp(24),pattern(24));
  inv41 : inv port map(temp(23),pattern(23));
  inv42 : inv port map(temp(22),pattern(22));
  inv43 : inv port map(temp(21),pattern(21));
  inv44 : inv port map(temp(20),pattern(20));
  inv45 : inv port map(temp(19),pattern(19));
  inv46 : inv port map(temp(18),pattern(18));
  inv47 : inv port map(temp(17),pattern(17));
  inv48 : inv port map(temp(16),pattern(16));
  inv49 : inv port map(temp(15),pattern(15));
  inv50 : inv port map(temp(14),pattern(14));
  inv51 : inv port map(temp(13),pattern(13));
  inv52 : inv port map(temp(12),pattern(12));
  inv53 : inv port map(temp(11),pattern(11));
  inv54 : inv port map(temp(10),pattern(10));
  inv55 : inv port map(temp(9),pattern(9));
  inv56 : inv port map(temp(8),pattern(8));
  inv57 : inv port map(temp(7),pattern(7));
  inv58 : inv port map(temp(6),pattern(6));
  inv59 : inv port map(temp(5),pattern(5));
  inv60 : inv port map(temp(4),pattern(4));
  inv61 : inv port map(temp(3),pattern(3));
  inv62 : inv port map(temp(2),pattern(2));
  inv63 : inv port map(temp(1),pattern(1));
  inv64 : inv port map(temp(0),pattern(0));
end structural;
