--entity prpt is
--  port(seed       : in bit_vector(31 downto 0);
--       load_seed  : in bit;  
--       polynomial : in bit_vector(31 downto 0);
--       reset      : in bit;
--       clock1     : in bit;
--       clock1_bar : in bit;
--       clock2     : in bit;
--       clock2_bar : in bit;
--       test_enable: in bit;
--       pattern    : out bit_vector(31 downto 0));
--begin
--  assert ((not clock1 = clock1_bar) or (not clock1'stable(2 ns))) report
--    "bad clock1 result" severity failure;
----  assert ((not clock2 = clock2_bar) or (not clock2'stable(2 ns))) report
----    "bad clock2 result" severity failure;
--end prpt;

architecture beh of prpt is

  signal work_pattern : bit_vector(31 downto 0);

begin

  process(seed,load_seed,polynomial,reset,clock1,test_enable)

    variable temp_pattern : bit_vector(31 downto 0); 
    variable old_temp_pattern : bit_vector(31 downto 0); 
    variable feedback : bit_vector(31 downto 0); 

  begin

    if reset = '1' then
      for i in temp_pattern'range loop
        temp_pattern(i) := '0';
      end loop;
    else
      if clock1 = '0' and not clock1'stable then
        if load_seed = '1' then
          temp_pattern := seed;
        end if; 
      elsif clock1 = '1' and not clock1'stable then
        if test_enable = '1' then
          old_temp_pattern := temp_pattern;
          for i in temp_pattern'low to (temp_pattern'high - 1) loop
            temp_pattern(i) := temp_pattern(i + 1);
          end loop;
          feedback(0) := polynomial(0) and old_temp_pattern(0);
          for i in (feedback'low + 1) to feedback'high loop
            feedback(i) := (polynomial(i) and old_temp_pattern(i)) xor 
                                          feedback(i-1);
          end loop;
          temp_pattern(31) := feedback(31);
        end if; 
      end if;
    end if;
    work_pattern <= temp_pattern;
  end process;
  process(clock2)
  begin
    if clock2 = '1' and not clock2'stable then
      pattern <= work_pattern;
    end if;
  end process;   
end beh;
