entity prpt_stage is
  port(seed       : in bit;
       load_seed  : in bit;
       polynomial : in bit;
       feed_in    : in bit;
       reset      : in bit;
       input      : in bit;
       clock1     : in bit;
       clock1_bar : in bit;
       clock2     : in bit;
       clock2_bar : in bit;
       test_enable: in bit;
       feed_out   : out bit;
       output     : out bit);
begin
  assert (((not clock1 = clock1_bar) or (not clock1'stable(2 ns))) 
     or (now = 0 ns)) report
    "bad clock1" severity failure;
--  assert ((not clock2 = clock2_bar) or (not clock2'stable(2 ns))) report
--    "bad clock2" severity failure;
end prpt_stage;
architecture structural of prpt_stage is

  component prpt_stage1 
    port(seed       : in bit;
         load_seed  : in bit;
         reset      : in bit;
         input      : in bit;
         clock1     : in bit;
         clock1_bar : in bit;
         clock2     : in bit;
         clock2_bar : in bit;
         test_enable: in bit;
         output     : out bit);
  end component;

  for all : prpt_stage1 use entity work.prpt_stage1(structural);

  component and_gate
    port  (signal X,Y:in bit;
           signal Output:out bit);
  end component;

  for all : and_gate use entity work.and_gate( and_gate );

  component Xor_Gate
    generic(constant tPLH:TIME:=0 ns;
            constant tPHL:TIME:=0 ns);
    port  (signal A:in bit;
           signal B:in bit;
           signal C:out bit);
  end component;

  for all : Xor_Gate use entity work.Xor_Gate( xor_gate );

  signal interm : bit;

begin
  
  prpt_stage1_1 : prpt_stage1 
          port map(seed,load_seed,reset,input,clock1,clock1_bar,clock2,
                   clock2_bar,test_enable,output);
  and_gate1 : and_gate port map(polynomial,input,interm);
  xor_gate1 : xor_gate port map(feed_in,interm,feed_out);

end structural;
