entity prpt_stage1 is
  port(seed       : in bit;
       load_seed  : in bit;
       reset      : in bit;
       input      : in bit;
       clock1     : in bit;
       clock1_bar : in bit;
       clock2     : in bit;
       clock2_bar : in bit;
       test_enable: in bit;
       output     : out bit);
begin
  assert (((not clock1 = clock1_bar) or (not clock1'stable(2 ns))) 
    or (now = 0 ns)) report
    "bad clock1" severity failure;
--  assert ((not clock2 = clock2_bar) or (not clock2'stable(2 ns))) report
--    "bad clock2" severity failure;
end prpt_stage1;
architecture structural of prpt_stage1 is

  component dff_reset 
    port(clock : in bit;
         clock_bar : in bit;
         D     : in bit;
         reset : in bit;
         Q_bar : out bit);
  end component;

  for all : dff_reset use entity work.dff_reset(beh);
  
  component and_gate
    port  (signal X,Y:in bit;
           signal Output:out bit);
  end component;

  for all : and_gate use entity work.and_gate( and_gate );

  component Xor_Gate
    generic(constant tPLH:TIME:=0 ns;
            constant tPHL:TIME:=0 ns);
    port  (signal A:in bit;
           signal B:in bit;
           signal C:out bit);
  end component;

  for all : Xor_Gate use entity work.Xor_Gate( xor_gate );

  signal interm1,interm2,interm3,interm4 : bit;
  signal zero : bit := '0';

begin
  
  dff_reset1 : dff_reset port map(clock1,clock1_bar,interm2,reset,interm3);
  dff_reset2 : dff_reset port map(clock2,clock2_bar,interm3,zero,output);
  and_gate1 : and_gate port map(load_seed,seed,interm1);
  and_gate2 : and_gate port map(input,test_enable,interm4);
  xor_gate1 : xor_gate port map(interm4,interm1,interm2);

end structural;
