entity test is end;
architecture test of test is
  
  component prpt 
    port(seed       : in bit_vector(31 downto 0);
         load_seed  : in bit;  
         polynomial : in bit_vector(31 downto 0);
         reset      : in bit;
         clock1     : in bit;
         clock1_bar : in bit;
         clock2     : in bit;
         clock2_bar : in bit;
         test_enable: in bit;
         pattern    : out bit_vector(31 downto 0));
  end component;

  for prpt1 : prpt use entity work.prpt(structural);
  for prpt2 : prpt use entity work.prpt(beh);
  for prpt3 : prpt use configuration work.prptconf;

  component inv
    generic(constant tPLH:TIME:=0 ns;
            constant tPHL:TIME:=0 ns);
    port (signal A:in bit;
          signal B:out bit);
  end component;

  for all : inv use entity work.inv( inv );

  component master_clock 
    generic
      ( constant clock_low_time  : time := 60 ns;
        constant duty_cycle_time : time := 40 ns);
    port
      ( master_go                : in bit;
        Phi1                     : buffer bit := '1');
  end component;

  for all : master_clock use entity work.master_clock(master_clock );

  component slave_clock 
    generic
      ( constant pulse_width  : time := 40 ns;
        constant pulse_delay  : time := 10 ns);
    port
      ( external_trigger         : in bit;
        Clock_out                : out bit := '0');
  end component;

  for all : slave_clock use entity work.slave_clock(slave_clock );

  component or_gate 
    port (X, Y     : in bit;
          Output   : out bit);
  end component;
  
  for all : or_gate use entity work.or_gate(or_gate);

  component and_gate
    port  (signal X,Y:in bit;
           signal Output:out bit);
  end component;

  for all : and_gate use entity work.and_gate( and_gate );

  signal pattern : bit_vector(95 downto 0);
-- polynomial must be shifted left 1 from what's in the book.
  signal polynomial : bit_vector(31 downto 0) := 
                         "00110000000000000000000000000000";
--                         "00101000000000000000000000000000";
--                         "00000000010000000000000000000111";
  signal seed : bit_vector(31 downto 0) := 
--                         "01010101010101010101010101010101";
                         "01010000000000000000000000000000";
  signal load_seed : bit := '0';
  signal reset : bit := '1';
  signal clock1 : bit := '1';
  signal clock1_bar : bit := '0';
  signal clock2 : bit := '0';
  signal clock2_bar : bit := '1';
  signal CP : bit := '1';
  signal stop : bit := '0';
  alias pat1 : bit_vector(31 downto 0) is pattern(95 downto 64);
  alias pat2 : bit_vector(31 downto 0) is pattern(63 downto 32);
  alias pat3 : bit_vector(31 downto 0) is pattern(31 downto 0);
  signal interm1,interm2 : bit;
  signal test_enable : bit := '1';

begin

  inv1 : inv port map(clock1,clock1_bar);
  inv2 : inv port map(clock2,clock2_bar);
  prpt1 : prpt 
        port map(seed,load_seed,polynomial,reset,clock1,clock1_bar,
                 clock2,clock2_bar,test_enable,pat1);
  prpt2 : prpt 
        port map(seed,load_seed,polynomial,reset,clock1,clock1_bar,
                 clock2,clock2_bar,test_enable,pat2);
  prpt3 : prpt 
        port map(seed,load_seed,polynomial,reset,clock1,clock1_bar,
                 clock2,clock2_bar,test_enable,pat3);

  master_clock1 : master_clock port map(stop,CP);
  slave_clock1 : slave_clock port map(CP,clock2);
  and_gate1 : and_gate port map(CP,test_enable,interm1);
  and_gate2 : and_gate port map(load_seed,CP,interm2);
  or_gate1 : or_gate port map(interm1,interm2,clock1);

  load_seed <= '1' after 50 ns,
               '0' after 150 ns,
               '1' after 2400 ns,
               '0' after 2495 ns,
               '1' after 3400 ns,
               '0' after 3495 ns,
               '1' after 4400 ns,
               '0' after 4495 ns,
               '1' after 5400 ns,
               '0' after 5495 ns;

  reset <= '0' after 30 ns,
           '1' after 2200 ns,
           '0' after 2390 ns,
           '1' after 3200 ns,
           '0' after 3390 ns,
           '1' after 4200 ns,
           '0' after 4390 ns,
           '1' after 5200 ns,
           '0' after 5390 ns;
         

  stop <= '1' after 100 ns,
          '0' after 7000 ns;
--          '0' after 14400000 ns;

  test_enable <= '1',
                 '0' after 2400 ns,
                 '1' after 4395 ns;

  seed <= "10100000000000000000000000000000" after 2400 ns,
          "11110000000000000000000000000000" after 3400 ns,
          "01010000000000000000000000000000" after 4400 ns,
          "00110000000000000000000000000000" after 5400 ns;

  process
    variable wait_var : boolean := true;
  begin
    if wait_var then
      wait for 40 ns;
      wait_var := false;
      assert (not pat1'stable) or (not pat2'stable) or (not pat3'stable) or
       ((pat1 = pat2) and (pat1 = pat3)) report "patterns do not match" 
       severity failure;
      wait for 55 ns;
    else
      wait for 100 ns;
      assert (not pat1'stable) or (not pat2'stable) or (not pat3'stable) or
       ((pat1 = pat2) and (pat1 = pat3)) report "patterns do not match" 
       severity failure;
      assert (stop = '1') report "done" severity failure;
    end if;
  end process;

end test;
