-- ------------------------------------------- --
-- Testbench to exercise 3 cascaded non-       --
-- symmetric filters                           --
-- ------------------------------------------- --

LIBRARY ieee;
USE ieee.std_logic_1164.all;

-- ------------------------------------------- --
ENTITY testbenchasm IS
END testbenchasm;
-- ------------------------------------------- --

-- ------------------------------------------- --
ARCHITECTURE xilinx OF testbenchasm IS
-- ------------------------------------------- --

-- ------------------------------------------- --
-- Constant declarations                       --
-- ------------------------------------------- --

  CONSTANT clock_period      : TIME := 100 NS;

-- ------------------------------------------- --
-- Signal declarations                         --
-- ------------------------------------------- --

  SIGNAL test_data           : std_logic_vector(7 DOWNTO 0);
  SIGNAL test_results        : std_logic_vector(21 DOWNTO 0);
  SIGNAL new_data            : std_logic;
  SIGNAL result_ready        : std_logic;
  SIGNAL ready_for_data      : std_logic;
  SIGNAL clock               : std_logic;

-- ------------------------------------------- --
-- Procedure declarations                      --
-- ------------------------------------------- --

  PROCEDURE clock_cycle( period : IN  TIME;
                   SIGNAL clock : OUT std_logic ) IS
  BEGIN

    clock <= '0'; WAIT FOR period / 2;
    clock <= '1'; WAIT FOR period / 2;

  END clock_cycle;

-- ------------------------------------------- --
-- Top level component instantiation           --
-- ------------------------------------------- --

  COMPONENT fircascadeasm
    PORT( data : IN  std_logic_vector(7 DOWNTO 0);
          rslt : OUT std_logic_vector(21 DOWNTO 0);
           rfd : OUT std_logic;
            nd : IN  std_logic;
           rdy : OUT std_logic;
            ck : IN  std_logic );
  END COMPONENT;

-- ------------------------------------------- --
BEGIN
-- ------------------------------------------- --

-- ------------------------------------------- --
-- Instantiate the composite design            --
-- ------------------------------------------- --

  uut : fircascadeasm PORT MAP ( data => test_data,
                                 rslt => test_results,
                                   nd => new_data,
                                  rdy => result_ready,
                                  rfd => ready_for_data,
                                   ck => clock );

-- ------------------------------------------- --
-- Define the stimulus to drive the filter     --
-- In this case, a unit implse response        --
-- ------------------------------------------- --

  stimulus : PROCESS
  BEGIN

    test_data <= (OTHERS => '0');
    new_data  <= '0';
    clock     <= '0';

    FOR i IN 1 TO 6 LOOP
      clock_cycle(clock_period, clock);
    END LOOP;

    test_data <= (0 => '1', OTHERS => '0');
    new_data  <= '1';
    clock_cycle(clock_period, clock);
    new_data  <= '0';
    test_data <= (OTHERS => '0');

    FOR i IN 1 TO 58 LOOP
      WHILE ready_for_data='0' LOOP
        clock_cycle(clock_period, clock);
      END LOOP;
      new_data  <= '1';
      clock_cycle(clock_period, clock);
      new_data  <= '0';
    END LOOP;
    WAIT;

  END PROCESS; -- stimulus

-- ------------------------------------------- --
END xilinx;
-- ------------------------------------------- --

-- ------------------------------------------- --
-- Plug the appropriate design into the UUT    --
-- ------------------------------------------- --

CONFIGURATION cfg_testbenchasm OF testbenchasm IS
  FOR xilinx
    -- To simulate the source HDL, including   --
    -- behavioural models for the various core --
    -- components, comment-out the follwing    --
    -- section.                                --
    -- ALTERNATIVELY...                        --
    -- To use the backannotated post-layout    --
    -- version of the design leave the follow- --
    -- ing segment of code uncommented         -- 
    FOR uut: fircascadeasm
      USE ENTITY WORK.fircascadeasm (structure);
      FOR structure 
        FOR ALL:roc USE ENTITY WORK.roc(roc_v)
          -- Simulate the device's power-on    --
          -- reset behaviour with a 1 NS pulse --
          -- on its GSR net                    --
          GENERIC MAP (width => 1 NS);
        END FOR; 
      END FOR;
    END FOR;
    -- End commentable section                 --
  END FOR;
END cfg_testbenchasm;
