-- output of CoreGen module generator
-- $RCSfile: serial.vhd,v $ $Revision: 1.1 $
-- ************************************************************************
--  Copyright (C) 1996 - Xilinx, Inc.
-- ************************************************************************
--
--  Description:
--  parallel to serial converter
--  

library IEEE;
use IEEE.STD_LOGIC_1164.all;
library xul;
use xul.ul_utils.all;

entity serial is
        port(pi  : in std_logic_vector( 8 - 1 downto 0 );
             sdi : in std_logic;
             l   : in std_logic;
             c   : in std_logic;
             ce  : in std_logic;
             sdo : out std_logic;
             po  : out std_logic_vector( 8 - 1 downto 0 ));
end serial;

architecture behv of serial is
  constant k : integer := 8;
begin

  process
    variable setup : boolean := TRUE;
    variable vsdi  : std_logic;
    variable vl    : std_logic;
    variable vpi   : std_logic_vector( k - 1 downto 0 );
    variable vsdo  : std_logic;
    variable vpo   : std_logic_vector( k - 1 downto 0 );
    variable s     : std_logic_vector( k - 1 downto 0 );
  begin
    if (setup = TRUE) then
      s := setall0(k);
      setup := FALSE;
    end if;

    vpi := std_logic_vector_2_var(pi);
    vsdi := rat(sdi);
    vl := rat(l);

    if (c'event and c='1' and c'last_value='0' and ce='1') then
      case vl is
        when '0' =>
          for i in 0 to k-2 loop
            s(i) := s(i+1);
          end loop;
          s(k-1) := vsdi;

        when '1' =>
          s := vpi;
        when others => 
      end case;

      po <= s;
      sdo <= s(0);

    end if;

    wait on c;

  end process;

end behv;


