-- $RCSfile: sqrootVHT.vhd,v $ $Revision: 1.5 $
-- ************************************************************************
--  Copyright (C) 1996 - Xilinx, Inc.
-- ************************************************************************
--
--  Description:
--  4K Pipeline Square Root
--  

library IEEE;
use IEEE.STD_LOGIC_1164.all;

library xul;
use xul.ul_utils.all;


ENTITY $COMPONENT_NAME IS
  PORT( din  : IN  std_logic_vector($INWIDTH-1 downto 0);
        c  : IN  std_logic;
        ce : IN  std_logic;
        dout : OUT std_logic_vector($OUTWIDTH-1 downto 0));
END $COMPONENT_NAME;

ARCHITECTURE behv OF $COMPONENT_NAME IS
FUNCTION max (a,b : integer) return integer IS
BEGIN
   IF a > b THEN return a;
   ELSE return b;
   END IF;
END max;
function minus (a, b : std_logic_vector;
		width : integer) return std_logic_vector is
variable ret : std_logic_vector(width-1 downto 0);
variable borrow : std_logic := '1';
begin
    FOR i IN 0 to width-1 LOOP
      ret(i) := a(i) XOR NOT(b(i)) XOR borrow;
      borrow := (a(i) AND (NOT b(i)))  OR 
           (a(i) AND  borrow) OR 
           ((NOT b(i)) AND borrow);
    END LOOP;
    return ret;
end minus;    

function gt (a, b : std_logic_vector;
	     width : integer) return boolean is
begin  -- gt
    for i in width-1 downto 0 loop
	if (a(i) > b(i)) then
	    return true;
        elsif (b(i) > a(i)) then
	    return false;
	end if;
    end loop;  -- i
    return false;
end gt;
    

SIGNAL startup : BOOLEAN := TRUE;
CONSTANT inwidth : INTEGER := $INWIDTH;
CONSTANT outwidth : INTEGER := $OUTWIDTH;
CONSTANT w : INTEGER := (inwidth+1)/2*2;
CONSTANT dw : INTEGER := max(w, outwidth);
TYPE   divarray IS ARRAY (0 to outwidth) of std_logic_vector(dw downto 0);
TYPE   resarray IS ARRAY (1 to outwidth) of std_logic_vector(outwidth-1 downto 0);
BEGIN
 PROCESS
 BEGIN
        startup <= FALSE;
        WAIT;
 END PROCESS;

 PROCESS (c)

   VARIABLE dividend : divarray;
   VARIABLE result : resarray;
   VARIABLE c1, c2 : std_logic_vector(outwidth+2 downto 0);
   BEGIN
     IF ((NOT(startup) AND rat(c) = 'X' AND rat(ce) /= '0') OR	
	 (c'event AND rat(c) = '1' AND rat(c'last_value) = '0' AND rat(ce) = 'X')) THEN
	FOR i IN 0 TO outwidth LOOP
		dividend(i) := setallX(dw);
	END LOOP;
	FOR i IN 1 TO outwidth LOOP
		result(i) := setallX(outwidth);
	END LOOP;
		
     ELSIF (c'event AND rat(c) = '1' AND rat(c'last_value) = '0' AND rat(ce) = '1') THEN
	  FOR i IN outwidth DOWNTO 2 LOOP
	     result(i)(i-1 downto 1):= result(i-1)(i-2 downto 0);
	     IF (i <= w/2) THEN
		IF(anyX(result(i-1)(i-2 downto 0)) OR
		   anyX(dividend(i-1)(w-i+1  downto w - 2*i))) THEN
		   dividend(i) (w-i+1 downto w - 2*i) := setallX(i+2);
		   result(i)(0) := 'X';	
		ELSE
		    c1(i+1 downto 0) := "0" & result(i-1)(i-2 downto 0) & "01";
		    c2(i+1 downto 0) := dividend(i-1)(w-i+1 downto w- 2*i);
		    if (gt(c1(i+1 downto 0), c2(i+1 downto 0), i+2)) then
		        dividend(i) (w-i+1 downto w - 2*i) := dividend(i-1) (w-i+1 downto w - 2*i); 
			result(i)(0) := '0';	
		    ELSE
      			dividend(i) (w-i+1 downto w - 2*i) := minus(c2(i+1 downto 0), c1(i+1 downto 0), i+2);
			result(i)(0) := '1';	
		    END IF;
		END IF;
		dividend(i)(w - 2*i-1 downto 0) :=
		      dividend(i-1)(w - 2*i-1 downto 0);
	    ELSE 
	       IF(anyX(result(i-1)(i-2 downto 0)) OR
                   anyX(dividend(i-1)(i downto 0))) THEN
                   dividend(i) (i downto 0) := setallX(i+1);
                   result(i)(0) := 'X';
                ELSE
		    c1(i+2 downto 0) := "00" & result(i-1)(i-2 downto 0) & "01";
		    c2(i+2 downto 0) := dividend(i-1)(i downto 0) & "00" ; 
		    -- If the subtraction cannot occur, then a maxm of i+1
		    -- bits from the dividend of this iteration can be
		    -- useful in the next iteration
		    IF (gt(c1(i+2 downto 0), c2(i+2 downto 0), i+3)) THEN
			dividend(i) (i downto 0) := dividend(i-1) (i-2 downto 0) & "00";
			result(i)(0) := '0';
		    ELSE
			dividend(i) (i downto 0) := minus(c2(i+2 downto 0), c1(i+2 downto 0), i+3)(i downto 0);
			result(i)(0) := '1';
		    END IF;
                END IF;
	       END IF;
	    END LOOP;

          IF(anyX(dividend(0)(w-1 downto w-2))) THEN
                   dividend(0)(w-1 downto w-2):= "XX";
                   result(1)(0) := 'X';
          ELSE
	      c2(1 downto 0) := dividend(0)(w-1 downto w-2);
	      c1(1 downto 0) := "01";
	      IF (gt(c1(1 downto 0), c2(1 downto 0), 2)) THEN
		  dividend(1)(w-1 downto w-2) := "00";
		  result(1)(0) := '0';
	      ELSE
		  dividend(1)(w-1 downto w-2) := minus(c2(1 downto 0), c1(1 downto 0), 2);
		  result(1)(0) := '1';
	      END IF;
	      dividend(1)(w-3 downto 0) := dividend(0)(w-3 downto 0);
          END IF;

	  IF (w > inwidth) THEN
	    dividend(0)(w -1) := '0';
	  END IF;
          dividend(0)(inwidth-1 downto 0) := din;
    ELSIF (startup) THEN 
	FOR i IN 0 TO outwidth LOOP
		dividend(i) := setall0(dw+1);
	END LOOP;
	FOR i IN 1 TO outwidth LOOP
		result(i) := setall0(outwidth);
	END LOOP;
    END IF; 
    dout <= result(outwidth);
   END PROCESS;
END behv;

